#!/bin/sh

# Пример скрипта, запускаемого программой PingSTAT при наступлении любых событий

# Назначаем имя log-файла
log_file=./pingstat.log

# При наступлении одного события скрипт запускается один раз. Если по одному
# пингеру наступает одновременно несколько событий, то скрипт будет запущен по
# одному разу для каждого события. Программа передает в скрипт следующие параметры:

# Строковое описание события, которое вызвало запуск скрипта. Возможные варианты:
# Timer - принято N пакетов от пингера (N задается в файле конфигурации)
# BitX - изменился бит X (X=0..7)
# MinTempError - температура опустилась ниже минимально допустимой границы
# MinTempOk - температура вернулась в допустимые пределы с нижней стороны
# MaxTempError - температура поднялась выше максимально допустимой границы
# MaxTempOk - температура вернулась в допустимые пределы с верхней стороны
# Warning - предупреждение: от пингера не получен ни один пакет в течение времени Ping_warning_timeout (задается в файое pingstat.conf)
# Dead - от пингера не получен ни один пакет в течение времени Ping_timeout (задается в файле pingstat.conf)
# Alive - возобновился поток пакетов от пингера
event=${1} 

# Параметры пингера, по которому зафиксировано изменение:
ip=${2} 
address=${3} 
description=${4} 

# По каждому биту передается два параметра:
# Состояние бита в двоичном виде: 1 - нормальное, 0 - ненормальное (описывается в файле pingstat.conf)
bit0_bin=${5}
# Состояние бита в текстовом виде (описывается в файле pingstat.conf)
bit0_str=${6} 

bit1_bin=${7} 
bit1_str=${8} 

bit2_bin=${9} 
bit2_str=${10} 

bit3_bin=${11} 
bit3_str=${12} 

bit4_bin=${13} 
bit4_str=${14}

bit5_bin=${15} 
bit5_str=${16}

bit6_bin=${17} 
bit6_str=${18}

bit7_bin=${19} 
bit7_str=${20}

# Значение температуры
temperature=${21} 

# Помещение всех входных параметров в log-файл
#echo ${1} ${2} ${3} ${4} ${5} ${6} ${7} ${8} ${9} ${10} ${11} ${12} ${13} ${14} ${15} ${16} ${17} ${18} ${19} ${20} ${21} >> $log_file

# Вывод того же на экран
echo ${1} ${2} ${3} ${4} ${5} ${6} ${7} ${8} ${9} ${10} ${11} ${12} ${13} ${14} ${15} ${16} ${17} ${18} ${19} ${20} ${21}

# Помещение в log-файл строки, содержащей дату, текущее время, ip пингера, адрес, событие
echo -n `date +"%Y.%m.%d %H:%M:%S" | cut -b "-19"`" - " >> $log_file
echo -n $ip $address $event "" >> $log_file

# Анализ питания сеть/аккумулятор и добавление сообщения в log-файл
if [ "X$event" = "XBit0" ]
then
  if [ "X$bit0_bin" = "X0" ]
  then
      echo -n "Питание в сети пропало" >> $log_file
  else
      echo -n "Питание в сети восстановилось" >> $log_file
  fi
fi

# Анализ событий Dead и Alive и отправка SMS
if [ "X$ip" = "X123.123.123.123" ]
then
  if [ "X$event" = "XDead" ]
  then
      ./mailer sms_dead.txt &
  fi
  if [ "X$event" = "XAlive" ]
  then
      ./mailer sms_alive.txt &
  fi
fi

# Анализ открывания двери и отправка SNMP Trap сообщения
if [ "X$event" = "XBit3" ]
then
  if [ "X$bit3_bin" = "X0" ] #1 - ненормальное состояние, 0 - нормальное состояние
  then
      snmptrap -v 2c -c public 192.168.2.2 "" 1.1.1.1.1 1.3.3.3.3 s "The door has been opened"
  else
      snmptrap -v 2c -c public 192.168.2.2 "" 1.2.2.2.2 1.3.3.3.3 s "The door has been closed"
   fi
fi

echo >> $log_file
